# Tutorials, Friendship & Symfony6

Well hi there! This repository holds the code and script
for the [Symfony6 Tutorials](https://symfonycasts.com/tracks/symfony) on SymfonyCasts.

## Setup

If you've just downloaded the code, congratulations!!

To get it working, follow these steps:

**Download Composer dependencies**

Make sure you have [Composer installed](https://getcomposer.org/download/)
and then run:

```
composer install
```

You may alternatively need to run `php composer.phar install`, depending
on how you installed Composer.

**Webpack Encore Assets**

This app uses Webpack Encore for the CSS, JS and image files.
Make sure you have [yarn](https://yarnpkg.com/lang/en/)
or `npm` installed (`npm` comes with Node) and then run:

```
yarn install
yarn encore dev --watch

# or
npm install
npm run watch
```

**Start the Symfony web server**

You can use Nginx or Apache, but Symfony's local web server
works even better.

To install the Symfony local web server, follow
"Downloading the Symfony client" instructions found
here: https://symfony.com/download - you only need to do this
once on your system.

Then, to start the web server, open a terminal, move into the
project, and run:

```
symfony serve
```

(If this is your first time using this command, you may see an
error that you need to run `symfony server:ca:install` first).

Now check out the site at `https://localhost:8000`

Have fun!

## Have Ideas, Feedback or an Issue?

If you have suggestions or questions, please feel free to
open an issue on this repository or comment on the course
itself. We're watching both :).

## SymfonyCasts Team Mix Tapes

Want to listen to *our* mixtapes? 

* Diego: https://tidal.com/browse/playlist/4b0dd1f6-c3d4-4886-8e31-c59455596528
* Victor: https://tidal.com/browse/playlist/e2473e0d-e4df-407e-b12c-f40765d1dd4b
* Danielle: https://tidal.com/browse/playlist/acd3fae7-10ea-43a4-be89-56a3f6f3040c
* Ryan: https://tidal.com/browse/playlist/96d88543-e1bb-4457-b38a-3afd7d71d1da
* Matias: https://tidal.com/browse/playlist/9f914493-5844-4fbc-8029-a828ee4d090d
* Leanna: https://tidal.com/browse/playlist/fb01a86a-802e-4861-9a20-a0d37244b696
* Vladimir: https://tidal.com/browse/playlist/0e78bb9e-a6ce-4548-9521-3e6779875978

... or for countries where Tidal isn't available:
https://open.spotify.com/user/31smny3k6o3kbqmmyzwebplayhda?si=8kq-n_8aRNOieXAOQJoleQ

## Rock 'N' Roll Band

If we were a rock 'n' roll band,
We'd travel all over the land.
We'd play and we'd sing and wear spangly things.
If we were a rock 'n' roll band.
If we were a rock 'n' roll band,
And we were up there on the stand,
The people would here us and love us and cheer us.
Hurray for that rock 'n' roll band.
If we were a rock 'n' roll band,
Then we'd have a million fans.
We'd giggle and laugh and sign autographs,
If we were a rock 'n' roll band.
If we were a rock 'n' roll band.
The people would all kiss our hands.
We'd be millionaires and have extra long hair,
If we were a rock 'n' roll band.
But we ain't no rock 'n' roll band,
We're just seven kids in the sand.
With homemade guitars and pails and jars
And drums of potato chip cans.
Just seven kids in the sand.
Talk'n and waven' our hands.
And dreamin' and thinkin' oh wouldn't it be grand,
If we were a rock 'n' roll band.

Shel Silverstein

## Thanks!

And as always, thanks so much for your support and letting
us do what we love!

<3 Your friends at SymfonyCasts
